﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Edu.WinForms.EsyWin.Forms
{
    public partial class MessageDialog : Form
    {
        protected bool Confirm { get; private set; }

        public MessageDialog()
        {
            InitializeComponent();
        }

        public void  ShowMessage(string message)
        {
            this.buttonNo.Visible = false;
            this.buttonYes.Visible = false;
            this.buttonOK.Visible = true;
            this.textBoxMessage.Text = message;
            textBoxMessage.Select(0, 0);
            this.ShowDialog();
        }

        public bool ShowConfirm(string message)
        {
            this.buttonNo.Visible = true;
            this.buttonYes.Visible = true;
            buttonNo.Location = buttonOK.Location;
            this.buttonOK.Visible = false;
            this.textBoxMessage.Text = message;
            textBoxMessage.Select(0, 0);
            this.ShowDialog();
            return Confirm;
        }

        private void buttonOK_Click(object sender, EventArgs e)
        {
            this.Hide();
        }

        private void MessageDialog_Load(object sender, EventArgs e)
        {

        }

        private void buttonYes_Click(object sender, EventArgs e)
        {
            Confirm = true;
            this.Hide();
        }

        private void buttonNo_Click(object sender, EventArgs e)
        {
            Confirm = false;
            this.Hide();
        }

        private void buttonStop_Click(object sender, EventArgs e)
        {
            throw new Exception("Stop!");
        }
    }
}
